<?php

namespace App\Console\Commands;
use App\Models\JobQueue;
use App\Models\TransactionModel;
use App\Models\User;
use App\Models\WalletModel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

use Illuminate\Console\Command;

class JobFailedToPending implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        $jobFail = JobQueue::where('job_status', 'FAILED')->get();
        if (count($jobFail) > 0) {
            foreach ($jobFail as $jobFails) {
                JobQueue::where('id', $jobFails->id)->update([
                    'job_status' => 'PENDING',
                ]);
            }
        }
    }
}
