<?php

namespace App\Console\Commands;

use App\Events\PusherEvent;
use App\Helpers\ResponseHelper;
use App\Models\ApiKey\ApikeyModel;
use App\Models\Microsoft\MicrosoftModel;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class MicrosoftBufeCommand implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        // استخراج اطلاعات از دیتابیس SQL Server
        $sqlServerProducts = DB::connection('sqlsrv')->table('tbl_mem_finger_template')->get();
        $this->getFingerToSave();

        // پیمایش اطلاعات استخراج شده
        foreach ($sqlServerProducts as $sqlServerProduct) {
            // چک کردن وجود رکورد در دیتابیس MySQL بر اساس card_id
            $mysqlProduct = DB::connection('mysql')->table('bufe_finger')->where('card_id', $sqlServerProduct->card_id)->first();

            if ($mysqlProduct) {
                // به‌روزرسانی رکورد در دیتابیس MySQL

                if ($sqlServerProduct->finger != $mysqlProduct->template){

                    DB::connection('mysql')->table('bufe_finger')
                        ->where('card_id', $sqlServerProduct->card_id)
                        ->update([
                            'finger_id' => $sqlServerProduct->finger_id,
                            'template' => $sqlServerProduct->finger,
                            'status' => false // اگر فیلد دیگری هم نیاز به به‌روزرسانی دارد
                        ]);
                    $this->getFingerToSave();
                } elseif ($sqlServerProduct->finger_id != $mysqlProduct->finger_id){
                    DB::connection('mysql')->table('bufe_finger')
                        ->where('card_id', $sqlServerProduct->card_id)
                        ->update([
                            'finger_id' => $sqlServerProduct->finger_id,
                            'template' => $sqlServerProduct->finger,
                            'status' => false // اگر فیلد دیگری هم نیاز به به‌روزرسانی دارد
                        ]);
                    $this->getFingerToSave();
                }
            } else {
                // اضافه کردن رکورد جدید در دیتابیس MySQL
                DB::connection('mysql')->table('bufe_finger')->insert([
                    'finger_id' => $sqlServerProduct->finger_id,
                    'card_id' => $sqlServerProduct->card_id,
                    'template' => $sqlServerProduct->finger,
                    'status' => false
                ]);
                $this->getFingerToSave();
            }
        }
    }

    public function getFingerToSave()
    {
        $data =  MicrosoftModel::where('status', 0)->first();
        if ($data){
            broadcast(new PusherEvent(['app' => 900, 'data' => ['template' => $data]]))->toOthers();
        }
    }
}
