<?php

namespace App\Console;

use App\Console\Commands\ApiKeyGeneration;
use App\Console\Commands\CheckToDeployIFPendingStatus;
use App\Console\Commands\DeleteExpiredSmsVerifications;
use App\Console\Commands\DeployLinesFromSqlServer;
use App\Console\Commands\JobFailedToPending;
use App\Console\Commands\MicrosoftBufeCommand;
use App\Console\Commands\JobFails;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();

        // کد برای حذف یک رکورد از دیتابیس را اینجا قرار دهید
        $schedule->job(new DeleteExpiredSmsVerifications())->everyThreeMinutes();
        $schedule->job(new ApiKeyGeneration())->hourly(); // به طور دوره‌ای هر ساعت اجرا شود
        $schedule->job(new MicrosoftBufeCommand())->everyTenMinutes(); // به طور دوره‌ای هر ساعت اجرا شود
        $schedule->job(new JobFails())->everyMinute(); // به طور دوره‌ای هر ساعت اجرا شود
        $schedule->job(new JobFailedToPending())->everyThreeMinutes(); // به طور دوره‌ای هر ساعت اجرا شود
        $schedule->job(new DeployLinesFromSqlServer())->everySixHours(); // به طور دوره‌ای هر ساعت اجرا شود

    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
