<?php

namespace App\Helpers;
use Illuminate\Http\JsonResponse;

class ResponseHelper
{
    public static function successResponse($status, $message, $data = [], $httpCode = 200): JsonResponse
    {
        if (count($data) > 0){

            return response()->json([
                'status' => $status,
                'message' => $message,
                'data' => $data,
            ], $httpCode);

        } else {

            return response()->json([
                'status' => $status,
                'message' => $message,
                'data' => (object)[],
            ], $httpCode);

        }
    }
    public static function unSuccessResponse($status, $message, $httpCode = 200): JsonResponse
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'data' => (object)[],
        ], $httpCode);
    }
    public static function systemErrorResponse($status, $message, $data = [], $httpCode ,$code = 200): JsonResponse
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'data' => (object)[],
            'code' => $code
        ], $httpCode);
    }

}
