<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\ApplicationsModel;
use Illuminate\Http\Request;

class ApplicationsController extends Controller
{
    //


    /**
     * @OA\Post(
     *     path="/v1/getApplication",
     *     summary="Get application by code",
     *     description="Retrieve application details by its code",
     *     tags={"Application Versions"},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"appCode"},
     *             @OA\Property(property="appCode", type="string", example="xyz123")
     *         )
     *     ),
     *     @OA\Response(
     *         response="200",
     *         description="Successful operation",
     *         @OA\JsonContent(
     *             @OA\Property(property="type", type="boolean", example=true),
     *             @OA\Property(property="message", type="string", example="نرم‌افزار یافت شد"),
     *             @OA\Property(property="application", type="object",
     *                 @OA\Property(property="id", type="integer", example=1),
     *                 @OA\Property(property="name", type="string", example="ashayer"),
     *                 @OA\Property(property="validate_template", type="string", example="ashayerValidate"),
     *                 @OA\Property(property="version", type="integer", example=127),
     *                 @OA\Property(property="database_version", type="integer", example=1),
     *                 @OA\Property(property="app_code", type="integer", example=21456),
     *                 @OA\Property(property="download_link", type="string", example="sadfsadfasdf"),
     *                 @OA\Property(property="created_at", type="string", format="date-time", example="2021-11-15T19:10:41.000000Z"),
     *                 @OA\Property(property="updated_at", type="string", format="date-time", example="2021-11-15T19:10:41.000000Z")
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response="404",
     *         description="Application not found",
     *         @OA\JsonContent(
     *             @OA\Property(property="type", type="boolean", example=false),
     *             @OA\Property(property="message", type="string", example="نرم‌افزار با این کد در سیستم یافت نشد")
     *         )
     *     )
     * )
     */
    public function getApplication(Request $request)
    {
        $appCode = $request->query('Code', 0);
        $app = ApplicationsModel::where('app_code', $appCode)->first();

        if ($app) {
            return response()->json(['status' => 'success', 'message' => 'نرم‌افزار یافت شد', 'application' => $app], 200);
        } else {
            return response()->json(['status' => 'failure', 'message' => 'نرم‌افزار با این کد در سیستم یافت نشد'], 404);
        }
    }

    public function getApplicationRules()
    {
        return response()->json(['status' => 1, 'message' => 'قوانین و مقررات استفاده با موفقیت دریافت شد', 'data' => ['title' => 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت', 'content' => '
        لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد، کتابهای زیادی در شصت و سه درصد گذشته حال و آینده، شناخت فراوان جامعه و متخصصان را می طلبد، تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی، و فرهنگ پیشرو در زبان فارسی ایجاد کرد، در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها، و شرایط سخت تایپ به پایان رسد و زمان مورد نیاز شامل حروفچینی دستاوردهای اصلی، و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.']], 200);
    }
}
