<?php

namespace App\Http\Controllers\Category;

use App\Helpers\ResponseHelper;
use App\Http\Controllers\Controller;
use App\Models\ApiKey\ApikeyModel;
use App\Models\Category\CategoryModel;
use App\Models\ErrorLogs\ErrorLogsModel;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function getCategory(Request $request)
    {
        $verifyApiKey = ApikeyModel::where('apikey', $request->header('apikey'))->first();
        if ($verifyApiKey){

            $category = CategoryModel::all();
            if (count($category) > 0) {
                return response()->json(['status' => 1, 'message' => 'لیست کتگوری ها با موفقیت دریافت شد', 'data' => $category]);
            } else {
                return response()->json(['status' => 0, 'message' => 'در سیستم هیچ کتگوری ثبت نشده است']);
            }
        } else {
            ErrorLogsModel::insert([
                'type' => 1,
                'description' => "Get Category | apikey auth unsuccessfully!",
                'ip_address' => $request->ip()
            ]);
            return ResponseHelper::systemErrorResponse(0, "خطا در احراز هویت سرویس", [],200,500);
        }
    }
}
