<?php

namespace App\Http\Controllers\Category;

use App\Helpers\ResponseHelper;
use App\Http\Controllers\Controller;
use App\Models\ApiKey\ApikeyModel;
use App\Models\Category\SubCategoryModel;
use App\Models\ErrorLogs\ErrorLogsModel;
use Illuminate\Http\Request;

class SubCategoryController extends Controller
{
    public function getSubCategoryById(Request $request){
        $verifyApiKey = ApikeyModel::where('apikey', $request->header('apikey'))->first();
        if ($verifyApiKey) {

            $getSubsById = SubCategoryModel::where('category_id', $request->category_id)->get();
            if (count($getSubsById) > 0) {
                return response()->json(['status' => 1, 'message' => 'لیست زیر دسته ها با موفقیت دریافت شد', 'data' => $getSubsById]);
            } else {
                return response()->json(['status' => 0, 'message' => 'در این دسته بندی زیر دسته ای تعریف نشده است']);
            }
        } else {

            ErrorLogsModel::insert([
                'type' => 1,
                'description' => "Get Category | apikey auth unsuccessfully!",
                'ip_address' => $request->ip()
            ]);
            return ResponseHelper::systemErrorResponse(0, "خطا در احراز هویت سرویس", [],200,500);
        }
    }
}
