<?php

namespace App\Http\Controllers\MicrosoftSqlRoutes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BusController extends Controller
{
    //

    public function getBusLocations(Request $request)
    {
        // Fetch data from the SQL Server database
        $sqlServerProducts = DB::connection('ecity_sqlsrv')->table('PLineT')->get();

        // Process the collection to encode binary fields
        $processedData = $sqlServerProducts->map(function ($item) {
            // Encode the 'Geo' field if it is not null
            if (!is_null($item->Geo)) {
                $item->Geo = base64_encode($item->Geo);
            }
            return $item;
        });

        // Convert the processed collection to JSON
        $json = $processedData->toJson();

        // Return the JSON response
        return response($json, 200)
            ->header('Content-Type', 'application/json');
    }

}
