<?php

namespace App\Http\Controllers\MicrosoftSqlRoutes;

use App\Events\PusherEvent;
use App\Helpers\ResponseHelper;
use App\Http\Controllers\Controller;
use App\Models\Microsoft\MicrosoftModel;
use App\Models\Post\PostModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class MicrosoftController extends Controller
{
    //

    public function savedFinger(Request $request)
    {
        $microsoftUpdate = MicrosoftModel::select("*")->where('card_id', $request->card_id)->where('finger_id', $request->finger_id)->update([
            'status' => true
        ]);
        if ($microsoftUpdate) {
            return response()->json(['status' => 1, 'message' => 'اطلاعات کاربر یافت شد و اثرانگشت بروزرسانی شد']);
        } else {
            return response()->json(['status' => 0, 'message' => 'بروزرسانی انجام نشد']);

        }
    }

    public function getUserInformation(Request $request)
    {


    }

    public function updateUserWallet(Request $request)
    {
        $type = $request->type;
        $price = $request->price;
        $card_id = $request->card_id;
        if (!isset($type)) {
            return ResponseHelper::systemErrorResponse(0, "تایپ تکرانش را مشخص کنید", [], 200, 201);
        }
        if (!isset($price)) {
            return ResponseHelper::systemErrorResponse(0, "مبلغ تراکنش را را مشخص کنید", [], 200, 202);
        }
        if (!isset($card_id)) {
            return ResponseHelper::systemErrorResponse(0, "شماره کارت شخص را مشخص کنید", [], 200, 203);
        }
        $sqlServerProducts = DB::connection('sqlsrv')->table('tbl_GhararDadItem')->select(DB::raw('SCard_ID, Name, Price, Tel'))->where('Scard_ID', $request->card_id)->orderBy('id', 'desc')->first();
        if ($sqlServerProducts) {
            $priceToAction = 0;
            if ($type == 1) {
                $priceToAction = (int)$sqlServerProducts->Price + $price;
            } else {
                $priceToAction = (int)$sqlServerProducts->Price - $price;
            }
            $updateSqlServerUser = DB::connection('sqlsrv')->table('tbl_GhararDadItem')->where('Scard_ID', $request->card_id)->update(
                [
                    'Price' => $priceToAction
                ]
            );

            if ($updateSqlServerUser) {
                $sqlServerProducts->Price = $priceToAction;
                return ResponseHelper::successResponse(1, "تراکنش با موفقیت انجام شد", [$sqlServerProducts], 200);
            } else {
                return ResponseHelper::unSuccessResponse(0, "خطا در انجام تراکنش مورد نظر", 200);
            }
        }
    }

    public function pusherTest(Request $request)
    {
        broadcast(new PusherEvent(['type' => 'notification', 'data' => ['user' => ['firstname' => 'alireza']]]))->toOthers();
    }

}
