<?php

namespace App\Http\Controllers\OtherAppSms;

use App\Http\Controllers\Controller;
use App\Http\Service\SmsSender;
use App\Models\ApplicationsModel;
use Illuminate\Http\Request;

class OtherAppSmsController extends Controller
{
    //

    protected $smsSender;

    public function __construct(SmsSender $smsSender)
    {
        $this->smsSender = $smsSender;
    }

    public function sendSms(Request $request)
    {
        $phone = $request->phoneNumber;
        $applicationCode = $request->applicationCode;

        if (!isset($phone)) {
            return response()->json(['status' => "خطا", 'message' => 'پارامتر های ارسالی اشتباه است', 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
        }

        if (!isset($applicationCode)) {
            return response()->json(['status' => "خطا", 'message' => 'پارامتر های ارسالی اشتباه است', 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
        }

        $findAppTemplate = ApplicationsModel::where('app_code', $applicationCode)->select('validate_template')->first();

        if ($findAppTemplate) {
            $template = $findAppTemplate->validate_template;
           return $this->smsSender->sendOtherApp($phone, $template);
        } else {
            return response()->json(['status' => "خطا", 'message' => 'کد اپلیکیشن اشتباه است', 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
        }
    }

}
