<?php

namespace App\Http\Controllers\Post;

use App\Helpers\ResponseHelper;
use App\Http\Controllers\Controller;
use App\Models\Category\CategoryModel;
use App\Models\Category\SubCategoryModel;
use App\Models\Gym\GymFilesModel;
use App\Models\Post\PostModel;
use App\Models\Post\PostSaveModel;
use App\Models\ProvinceAndCity\CityModel;
use App\Models\ProvinceAndCity\ProvinceModel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use function React\Promise\all;
use App\Http\Service\LocationService;
class PostController extends Controller
{
    //
    protected $locationService;

    public function __construct(LocationService $locationService)
    {
        $this->locationService = $locationService;
    }

  
    public function allPostsInHome(Request $request)
    {
        // دریافت شماره صفحه و اندازه صفحه از درخواست، با مقدار پیش‌فرض در صورت عدم ارائه
        $pageNumber = $request->query('pageNumber', 1);
        $pageSize = $request->query('pageSize', 5);
         $language = $request->header('language');
        // محاسبه آفست
        $offset = ($pageNumber - 1) * $pageSize;
    
        // ساخت query اولیه
        $query = PostModel::query();
    
        // افزودن فیلتر بر اساس زبان
        if ($language === 'fa') {
            // فیلتر کردن رکوردهایی که شامل کاراکترهای فارسی هستند
            $query->where('name', 'REGEXP', '[\x{600}-\x{6FF}]');
        } else if ($language === 'en') {
            // فیلتر کردن رکوردهایی که شامل کاراکترهای انگلیسی هستند
            $query->where('name', 'REGEXP', '[a-zA-Z]');
        }
    
        // دریافت تعداد کل پست‌ها با توجه به فیلتر زبان
        $totalPosts = $query->count();
    
        // دریافت پست‌ها با استفاده از صفحه‌بندی
        $allPost = $query->orderBy('id', 'desc')->offset($offset)->limit($pageSize)->get();
        
        if ($allPost->count() > 0) {
            $posts = []; // آرایه‌ای برای نگهداری پست‌ها
    
            foreach ($allPost as $item) {
                $post = $this->formatPost($item);
                $posts[] = $post;
            }
    
            // آماده‌سازی داده‌های پاسخ با اطلاعات صفحه‌بندی
            $response = [
                'status' => 1,
                'message' => "لیست پست‌ها با موفقیت دریافت شد",
                'data' => $posts
                        ];
    
            return response()->json($response);
        } else {
            return ResponseHelper::unSuccessResponse(0, "در سامانه پستی ثبت نشده است");
        }
    }
    
    public function postDetail(Request $request)
    {
        $postData = PostModel::where('id', $request->post_id)->first();
        if ($postData) {

            $itemSubCategory = $postData->sub_category_id;
            $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();

            $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;

            // دریافت نام شهر و استان
            list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($postData->city_id);
        // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($postData->created_at);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
            $post = [
                'id' => $postData->id,
                'name' => $postData->name,
                'seller' => $postData->seller,
                'price' => $postData->price,
                'image' => json_decode($postData->image, true), // Decode the JSON string
                'address' => ['lat' => $postData->location_lat, 'long' => $postData->location_long],
                'discountPercent' => $postData->discountPercent,
                'phone' => $postData->phone,
                'description' => $postData->description,
                'location' => $postData->location,
                'expire_date' => $postData->expire_date,
                'created_at' => $postData->created_at,
                'updated_at' => $postData->updated_at,
                'cat_names' => $category_name . ', ' . $sub_data->title,
                'city' => $cityAndTimeInfo,
            ];
            $postIsSave = PostSaveModel::where('post_id', $postData->id)->where("user_id", Auth::user()->getAuthIdentifier())->first();
            if ($postIsSave) {
                $post['isSave'] = true;
            } else {
                $post['isSave'] = false;
            }

            return ResponseHelper::successResponse(1, "پست با موفقیت دریافت شد", $post, 200);
        } else {
            return ResponseHelper::unSuccessResponse(0, "در سامانه پستی ثبت نشده است");
        }
    }

    /**
     * فرمت‌دهی به اطلاعات یک پست
     *
     * @param $item
     * @return array
     */
    private function formatPost($item)
    {
        // دیکود کردن رشته JSON تصاویر
        $images = json_decode($item->image, true);
        // دریافت اولین URL تصویر
        $firstImage = isset($images[0]) ? $images[0] : null;

        // دریافت نام دسته‌بندی و زیر دسته‌بندی
        $itemSubCategory = $item->sub_category_id;
        $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
        $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;

        // دریافت نام استان و شهر
        list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($item->city_id);

        // تاریخ و زمان ایجاد پست
        $postCreatedAt = $item->created_at;

        // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($postCreatedAt);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
        return [
            'id' => $item->id,
            'name' => $item->name,
            'seller' => $item->seller,
            'price' => $item->price,
            'image' => $firstImage,
            'address' => ['lat' => $item->location_lat, 'long' => $item->location_long],
            'discountPercent' => $item->discountPercent,
            'cat_names' => $category_name . ', ' . $sub_data->title,
            'city' => $cityAndTimeInfo,
        ];
    }

    public function postSearch(Request $request)
    {
        $name = $request->name;

        if (!isset($name)) {
            return ResponseHelper::systemErrorResponse(0, "مقدار نام نمیتواند خالی باشد", [], 200, 190);
        }
        
        // جستجو در تیبل post بر اساس کلمات
        $postQuery = PostModel::query();
        $postQuery->orWhere('name', 'like', '%' . $name . '%');
        $posts = $postQuery->get();
    
        // جستجو در تیبل city بر اساس کلمات
        $cityQuery = CityModel::query();
        $cityQuery->orWhere('name', 'like', '%' . $name . '%');
        $cities = $cityQuery->get();
    
        $results = [];
    
        if (count($posts) > 0) {
            foreach ($posts as $item) {
                $images = json_decode($item->image, true); // Decode the JSON string
                $firstImage = isset($images[0]) ? $images[0] : null; // Retrieve the first image URL
    
                $itemSubCategory = $item->sub_category_id;
                $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
    
                $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;
                list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($item->city_id);
               // تبدیل رشته تاریخ به شیء Carbon
               $postCreatedAtCarbon = Carbon::parse($item->created_at);

               // زمان فعلی
               $now = Carbon::now();

              // محاسبه تفاوت‌ها
             $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
             $diffInHours = $now->diffInHours($postCreatedAtCarbon);
             $diffInDays = $now->diffInDays($postCreatedAtCarbon);
             $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
             $diffInYears = $now->diffInYears($postCreatedAtCarbon);


             // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
                $results[] = [
                    'id' => $item->id,
                    'name' => $item->name,
                    'seller' => $item->seller,
                    'price' => $item->price,
                    'image' => $firstImage,
                    'address' => ['lat' => $item->location_lat, 'long' => $item->location_long],
                    'discountPercent' => $item->discountPercent,
                    'cat_names' => $category_name . ', ' . $sub_data->title,
                    'city' => $cityAndTimeInfo
                ];
            }
        }
    
        if (count($cities) > 0) {
            foreach ($cities as $city) {
                $data = PostModel::where('city_id', $city->id)->first();
                if ($data) {
                    $images = json_decode($data->image, true); // Decode the JSON string
                    $firstImage = isset($images[0]) ? $images[0] : null; // Retrieve the first image URL
        
                    $itemSubCategory = $data->sub_category_id;
                    $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
        
                    $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;
                    list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($data->city_id);
    
                            // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($data->created_at);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
                    $results[] = [
                        'id' => $data->id,
                        'name' => $data->name,
                        'seller' => $data->seller,
                        'price' => $data->price,
                        'image' => $firstImage,
                        'address' => ['lat' => $data->location_lat, 'long' => $data->location_long],
                        'discountPercent' => $data->discountPercent,
                        'cat_names' => $category_name . ', ' . $sub_data->title,
                        'city' => $cityAndTimeInfo
                    ];
                }else {
                    return response()->json(['status' => 0, 'message' => "نتیجه یافت نشد"]);
                }    
            } 
        }
    
        if (count($results) > 0) {
            return response()->json(['status' => 1, 'message' => "نتیجه جستجو برای شما لیست شد", 'data' => $results]);
        } else {
            return response()->json(['status' => 0, 'message' => "نتیجه یافت نشد"]);
        }
    }
    public function insertPhoto(Request $request)
    {
        $data = $request->all();

        // Handle the file upload
        $images = $request->file('image');
        $imageNames = [];
        foreach ($images as $image) {

            $newName = rand() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('/uploads'), $newName);
            $imageNames[] = $newName;
        }
        // Assuming $imageNames contains the filenames of the saved images

        // Now create download links for each image
        $imageUrls = [];
        foreach ($imageNames as $imageName) {
            $imageUrl = asset('/uploads/' . $imageName);
            $imageUrls[] = $imageUrl;
        }
        $post = PostModel::find($request->post_id);

        if (!$post) {
            return ResponseHelper::systemErrorResponse(0, 'پست یافت نشد', [], 404, 200);
        }

        $post->image = json_encode($imageUrls);
        $post->save();

        $images = json_decode($post->image);
        return response()->json(['status' => 1, 'message' => 'تصویر با موفقیت بروزرسانی شد', 'data' => (object)['image' => $images]]);
    }


    public function insert(Request $request)
    {
        $data = $request->all();


        // Handle the file upload
        $images = $request->file('image');
        if ($images != null) {

            $imageNames = [];
            foreach ($images as $image) {

                $newName = rand() . '.' . $image->getClientOriginalExtension();
                $image->move(public_path('/uploads'), $newName);
                $imageNames[] = $newName;
            }
            // Assuming $imageNames contains the filenames of the saved images

            // Now create download links for each image
            $imageUrls = [];
            foreach ($imageNames as $imageName) {
                $imageUrl = asset('/uploads/' . $imageName);
                $imageUrls[] = $imageUrl;
            }

        } else {
            $imageUrls = null;
        }


        $location_lat = 0.0;
        $location_long = 0.0;
        $price = 0;
        $discountPercent = 0;
        // اعتبارسنجی داده‌ها با استفاده از isset
        if (!isset($data['name']) || !is_string($data['name']) || strlen($data['name']) > 255) {
            return ResponseHelper::systemErrorResponse(0, 'نام معتبر نیست', [], 400, 190);
        }
        if (isset($data['price'])) {
            $price = $data['price'];
        }
        if (isset($data['discountPercent'])) {
            $discountPercent = $data['discountPercent'];
        }
        if (isset($data['location_lat'])) {
            $location_lat = $data['location_lat'];
        }
        if (isset($data['location_long'])) {
            $location_long = $data['location_long'];
        }
        
        if (!isset($data['city_id'])) {
            return ResponseHelper::systemErrorResponse(0, 'ایدی شهر الزامیست', [], 400, 454);
        }
        if (!isset($data['location'])) {
            return ResponseHelper::systemErrorResponse(0, 'آدرس باید وارد شود', [], 400, 198);
        }
        if (!isset($data['description'])) {
            return ResponseHelper::systemErrorResponse(0, 'توضیحات باید وارد شود', [], 400, 198);
        }
        if (!isset($data['sub_category_id'])) {
            return ResponseHelper::systemErrorResponse(0, 'مقدار ایدی زیر دسته باید وارد شود', [], 400, 200);
        }
        list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($data['city_id']);


        $post = new PostModel();
        $post->name = $data['name'];
        $post->sub_category_id = $data['sub_category_id'];
        $post->description = $data['description'];
        $post->price = $price;
        $post->discountPercent = $discountPercent;
        $post->phone = Auth::user()->phone;
        $post->seller = Auth::user()->getAuthIdentifier();
        $post->location_lat = $location_lat;
        $post->location_long = $location_long;
        $post->location = $data['location'];
        $post->city_id = $data['city_id'];
        $post->image = json_encode($imageUrls);
        $post->expire_date = Carbon::now()->addMonth();
        $post->save();

        $post->image = json_decode($post->image);
        $post->price = (string)$post->price;
        $post['city'] = $city_name . '،' . $province_name;
        return response()->json(['status' => 1, 'message' => "پست جدید با موفقیت ایجاد شد", 'data' => $post], 200);
    }

    function update(Request $request)
    {
        $post = PostModel::find($request->post_id);

        if (!$post) {
            return ResponseHelper::systemErrorResponse(0, 'پست یافت نشد', [], 404, 200);
        }

        $data = $request->all();

        // اعتبارسنجی داده‌ها با استفاده از isset
        $post->name = $data['name'] ?? $post->name;
        $post->description = $data['description'] ?? $post->description;
        $post->price = $data['price'] ?? $post->price;
        $post->discountPercent = $data['discountPercent'] ?? $post->discountPercent;
        $post->phone = Auth::user()->phone ?? $post->phone;
        $post->seller = Auth::user()->getAuthIdentifier() ?? $post->seller;
        $post->location_lat = $data['location_lat'] ?? $post->location_lat;
        $post->location_long = $data['location_long'] ?? $post->location_long;
        $post->location = $data['location'] ?? $post->location;
        $post->city_id = $data['city_id'] ?? $post->city_id;
        $post->expire_date = $data['expire_date'] ?? $post->expire_date;
        $post->save();
        $images = json_decode($post->image, true); // Decode the JSON string

        list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($data['city_id'] ?? $post->city_id);
        $post->image = $images;
        $post['city'] = $city_name . '،' . $province_name;

        return response()->json(['status' => 1, 'message' => "پست با موفقیت بروزرسانی شد", 'data' => $post], 200);
    }

    public function getPostBySubsCategoryID(Request $request)
    {
        $posts = PostModel::where('sub_category_id', $request->sub_category_id)->get();
        if (count($posts) > 0) {

            $post = []; // Initialize an array to hold all posts
            foreach ($posts as $item) {
                $images = json_decode($item->image, true); // Decode the JSON string
                $firstImage = isset($images[0]) ? $images[0] : null; // Retrieve the first image URL
                $itemSubCategory = $item->sub_category_id;
                $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
    
                $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;
                list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($item->city_id);
        // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($item->created_at);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
                $post[] = [
                    'id' => $item->id,
                    'name' => $item->name,
                    'seller' => $item->seller,
                    'price' => $item->price,
                    'image' => $firstImage,
                    'address' => ['lat' => $item->location_lat, 'long' => $item->location_long],
                    'discountPercent' => $item->discountPercent,
                    'cat_names' => $category_name . '، ' . $sub_data->title,
                    'city' => $cityAndTimeInfo
                ];
            }
            return response()->json(['status' => 1, 'message' => 'لیست پست ها براساس زیردسته یافت شد', 'data' => $post]);
        } else {
            return response()->json(['status' => 0, 'message' => 'در این زیر دسته پست یافت نشد']);
        }
    }

    public function savePost(Request $request)
    {
        $post_id = $request->post_id;
        $user = Auth::user();
        if (!isset($post_id)) {
            return ResponseHelper::unSuccessResponse(0, "پست ایدی نمیتواند خالی باشد", 401);
        }


        $find_post = PostModel::where("id", $post_id)->first();
        if ($find_post) {

            $find_post_in_savedPosts = PostSaveModel::where('user_id', Auth::user()->getAuthIdentifier())->where('post_id', $post_id)->first();
            if ($find_post_in_savedPosts){
                PostSaveModel::where('user_id', Auth::user()->getAuthIdentifier())->where('post_id', $post_id)->delete();
                return response()->json(['status' => 1, 'message' => 'پست مربوطه از لیست ذخیره شده ها حذف شد']);
            } else {
                $post = new PostSaveModel();
                $post->user_id = Auth::user()->getAuthIdentifier();
                $post->post_id = $post_id;
                $post->save();

                $post = PostModel::find($post_id);
                $images = json_decode($post->image, true); // Decode the JSON string
                $firstImage = isset($images[0]) ? $images[0] : null; // Retrieve the first image URL

                $itemSubCategory = $post->sub_category_id;
                $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
    
                $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;
                list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($post->city_id);
        // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($post->created_at);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
                $posts = [
                    'id' => $post->id,
                    'name' => $post->name,
                    'seller' => $post->seller,
                    'price' => $post->price,
                    'image' => $firstImage,
                    'address' => ['lat' => $post->location_lat, 'long' => $post->location_long],
                    'discountPercent' => $post->discountPercent,
                    'cat_names' => $category_name .'، '. $sub_data->title,
                    'city' => $cityAndTimeInfo

                ];
                return response()->json(['status' => 1, 'message' => 'پست ذخیره شد', 'data' => (object)$posts]);

            }


        } else {
            return response()->json(['status' => 0, 'message' => 'پست با این ایدی یافت نشد']);

        }
    }

    public function getSavedPosts()
    {
        $user = Auth::user();


        $find_post = PostSaveModel::where("user_id", $user->getAuthIdentifier())->get();
        if (count($find_post) > 0) {
            return response()->json(['status' => 1, 'message' => 'پست های ذخیره شده شما با موفقیت لیست شد', 'data' => $find_post]);
        } else {
            return response()->json(['status' => 0, 'message' => 'شما پست ذخیره شده ای ندارید']);

        }

    }

    public function getSavedPost(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->getAuthIdentifier();

        // واکشی پست‌های ذخیره‌شده کاربر
        $savedPosts = PostSaveModel::where('user_id', $user_id)->orderBy('id', 'desc')->get();

        // واکشی اطلاعات پست‌ها
        $posts = [];
        foreach ($savedPosts as $savedPost) {
            $post = PostModel::find($savedPost->post_id);
            if ($post) {
                $images = json_decode($post->image, true); // Decode the JSON string
                $firstImage = isset($images[0]) ? $images[0] : null; // Retrieve the first image URL

                $itemSubCategory = $post->sub_category_id;
                $sub_data = SubCategoryModel::where('id', $itemSubCategory)->first();
    
                $category_name = CategoryModel::where('id', $sub_data->category_id)->first()->title;
                list($city_name, $province_name) = $this->locationService->getCityAndProvinceNames($post->city_id);

                        // تبدیل رشته تاریخ به شیء Carbon
        $postCreatedAtCarbon = Carbon::parse($post->created_at);

        // زمان فعلی
        $now = Carbon::now();

        // محاسبه تفاوت‌ها
        $diffInMinutes = $now->diffInMinutes($postCreatedAtCarbon);
        $diffInHours = $now->diffInHours($postCreatedAtCarbon);
        $diffInDays = $now->diffInDays($postCreatedAtCarbon);
        $diffInMonths = $now->diffInMonths($postCreatedAtCarbon);
        $diffInYears = $now->diffInYears($postCreatedAtCarbon);


        // نمایش تفاوت‌ها

// تعیین مقدار $cityAndTimeInfo بر اساس تفاوت زمانی
$cityAndTimeInfo = "";
if ($diffInMinutes < 60) {
    $cityAndTimeInfo = $diffInMinutes . " دقیقه پیش در " . $city_name;
} elseif ($diffInHours < 24) {
    $cityAndTimeInfo = $diffInHours . " ساعت پیش در " . $city_name;
} elseif ($diffInDays < 30) {
    $cityAndTimeInfo = $diffInDays . " روز پیش در " . $city_name;
} elseif ($diffInMonths < 12) {
    $cityAndTimeInfo = $diffInMonths . " ماه پیش در " . $city_name;
} else {
    $cityAndTimeInfo = $diffInYears . " سال پیش در " . $city_name;
}
                $posts[] = [
                    'id' => $post->id,
                    'name' => $post->name,
                    'seller' => $post->seller,
                    'price' => $post->price,
                    'image' => $firstImage,
                    'address' => ['lat' => $post->location_lat, 'long' => $post->location_long],
                    'discountPercent' => $post->discountPercent,
                    'cat_names' => $category_name . ', ' . $sub_data->title,
                    'city' => $cityAndTimeInfo
                ];

            }
        }

        // اگر هیچ پستی یافت نشد
        if (empty($posts)) {
            return response()->json(['status' => 0, 'message' => 'هیچ پستی ذخیره نشده است']);
        }

        // بازگشت اطلاعات پست‌ها
        return response()->json(['status' => 1, 'message' => 'پست‌های ذخیره‌شده کاربر', 'data' => $posts]);
    }

}
