<?php

namespace App\Http\Controllers;

use App\Helpers\ResponseHelper;
use App\Http\Service\SmsSender;
use App\Models\ApiKey\ApikeyModel;
use App\Models\ErrorLogs\ErrorLogsModel;
use App\Models\SmsVerify;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Response;
use Tymon\JWTAuth\Facades\JWTAuth;

class SmsController extends Controller
{
    //

    protected $smsSender;

    public function __construct(SmsSender $smsSender)
    {
        $this->smsSender = $smsSender;
    }


    public function sendSms(Request $request)
    {
        $verifyApiKey = ApikeyModel::where('apikey', $request->header('apikey'))->first();
        if ($verifyApiKey) {

            if (!isset($request->phone)) {
                return ResponseHelper::systemErrorResponse(0, "شماره تماس نمیتواند خالی باشد", 125,200,125);
            }
            $receptor = $request->phone; // شماره تلفن مقصد

            return $this->smsSender->send($receptor);
        } else {
            ErrorLogsModel::insert([
                'type' => 1,
                'description' => "Send OTP Sms | apikey auth unsuccessfully!",
                'ip_address' => $request->ip()
            ]);
            return ResponseHelper::systemErrorResponse(0, "خطا در احراز هویت سرویس", [],200,500);
        }
    }

    /**
     * @OA\Post(
     *     path="/v1/verify",
     *     summary="Verify Phone Number",
     *     description="Verify the phone number by the provided code and generate JWT token if successful",
     *     tags={"SMS & Authentication"},
     *     @OA\RequestBody(
     *         required=true,
     *         description="Request body for phone number verification",
     *         @OA\JsonContent(
     *             required={"phone", "code"},
     *             @OA\Property(property="phone", type="string", example="09211348687"),
     *             @OA\Property(property="code", type="string", example="123456")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Phone number verified successfully",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="status", type="integer", example=1),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="token", type="string", example="Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9..."),
     *             ),
     *             @OA\Property(property="message", type="string", example="کد وارد شده تایید شد، خوش آمدید")
     *         )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Failed to verify phone number",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="status", type="integer", example=0),
     *             @OA\Property(property="message", type="string", example="کد وارد شده اشتباه می‌باشد یا از قبل استفاده شده است"),
     *             @OA\Property(property="code", type="integer", example=120)
     *         )
     *     )
     * )
     */
    public function verify(Request $request)
    {
        $verifyApiKey = ApikeyModel::where('apikey', $request->header('apikey'))->first();
        if ($verifyApiKey) {


            $receptor = $request->phone; // شماره تلفن مقصد
            $email = $request->email; // شماره تلفن مقصد
            $verify_code = $request->code;

            if (!isset($receptor)) {
                return ResponseHelper::systemErrorResponse(0, "شماره تماس نمیتواند خالی باشد", [], 200, 125);
            }
            if (!isset($verify_code)) {
                return ResponseHelper::systemErrorResponse(0, "کد تاییدی نمیتواند خالی باشد", [], 200, 126);
            }

            $checkVerifyIsActive = SmsVerify::where('phone', $receptor)->where('status', 0)->where('verifyCode', $verify_code)->first();
            if ($checkVerifyIsActive) {
                $checkVerifyIsActive->update(['status' => 1]);


            $user = User::where('phone', $receptor)->first();

            if (!$user) {
                $user = new User();
                $user->first_name = ' ';
                $user->last_name = ' ';
                $user->phone = $receptor;
                $user->email = ' ';
                $user->password = ' '; // مقدار دهی موقت
                $user->login_at = now();
                $user->save();

                $token = JWTAuth::fromUser($user);

                $token = "Bearer " . $token;
                return ResponseHelper::successResponse(1, "کد وارد شده تایید شد، خوش آمدید", ['token' => $token, 'user' => $user]);
            } else {

                $token = JWTAuth::fromUser($user);

                $token = "Bearer " . $token;
                return ResponseHelper::successResponse(1, "کد وارد شده تایید شد، خوش آمدید", ['token' => $token, 'user' => $user]);


                // ایجاد توکن JWT برای کاربر

                }

            } else {
                return ResponseHelper::unSuccessResponse(0, "کد وارد شده اشتباه میباشد یا از قبل استفاده شده است", 401);
            }
        } else {
            ErrorLogsModel::insert([
                'type' => 1,
                'description' => "Verify OTP Code | apikey auth unsuccessfully!",
                'ip_address' => $request->ip()
            ]);
            return ResponseHelper::systemErrorResponse(0, "خطا در احراز هویت سرویس",[],200,500);
        }
    }

}
