<?php

namespace App\Http\Service;

use App\Models\ProvinceAndCity\ProvinceModel;
use App\Models\ProvinceAndCity\CityModel;

class LocationService
{
    /**
     * دریافت نام شهر و استان
     *
     * @param int $cityId
     * @return array
     */
    public function getCityAndProvinceNames($cityId)
    {
        if ($cityId == 0) {
            return ["تهران", "تهران"];
        } else {
            $city = CityModel::where('id', (int)$cityId)->first();

            if (!$city) {
                return ["تهران", "تهران"];
            } else {
                $province = ProvinceModel::where("id", (int)$city->province_id)->first();
                return [$city->name, $province->name];
            }
        }
    }
}
