<?php

namespace App\Http\Service;

use App\Helpers\ResponseHelper;
use App\Models\ApiKey\ApikeyModel;
use App\Models\ErrorLogs\ErrorLogsModel;
use App\Models\SmsVerify;
use Exception;
use Ghasedak\GhasedakApi;
use Ghasedak\Laravel\GhasedakFacade;
use GuzzleHttp\Client;

class SmsSender
{
    protected $api;

    public function __construct()
    {
        $this->api = new GhasedakApi(env('GHASEDAKAPI_KEY'));
    }

    /**
     * @OA\Post(
     *     path="/v1/sendAuthSms",
     *     summary="Send Authentication SMS",
     *     description="Send authentication SMS to the specified phone number.",
     *     tags={"SMS & Authentication"},
     *     @OA\RequestBody(
     *         required=true,
     *         description="Phone number to which the authentication SMS will be sent.",
     *         @OA\JsonContent(
     *             required={"phone"},
     *             @OA\Property(property="phone", type="string", example="09211348687")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Authentication SMS sent successfully",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="status", type="integer", example=1),
     *             @OA\Property(property="message", type="string", example="کد تاییدی با موفقیت ارسال شد")
     *         )
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Invalid request format",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="status", type="integer", example=0),
     *             @OA\Property(property="message", type="string", example="Invalid request format")
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Internal server error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="status", type="integer", example=0),
     *             @OA\Property(property="message", type="string", example="Internal server error")
     *         )
     *     )
     * )
     */
    public function send($receptor)
    {
        // Check for the existence of a pre-confirmation code
        $checkVerifyIsActive = SmsVerify::where('phone', $receptor)->where('status', 0)->get();

        if (count($checkVerifyIsActive) > 0) {
            return ResponseHelper::unSuccessResponse(0, "کد تاییدی از قبل ارسال شده است", 200);
        }


        // Creating a verification code
        $param1 = rand(100000, 999999);

        // Create a new Guzzle client instance
        $client = new Client();

        // Define the request parameters
        $params = [
            'receptor' => $receptor,
            'template' => 'validate',
            'type' => 1,
            'param1' => $param1
        ];

        try {
            // Send a POST request to the specified URL with the parameters
            $response = $client->request('POST', 'https://api.ghasedak.me/v2/verification/send/simple', [
                'form_params' => $params,
                'headers' => [
                    'apikey' => env('GHASEDAKAPI_KEY'),
                    'cache-control' => 'no-cache',
                    'content-type' => 'application/x-www-form-urlencoded',
                    'Accept' => 'application/json'
                ]
            ]);

            // Get the response body as a string
            $body = $response->getBody()->getContents();

            $responseArray = json_decode($body, true); // convert json to array


            if ($responseArray !== null && array_key_exists('result', $responseArray)) {
                // find response code from result of ghasedak panel
                $items = $responseArray['items'];

                if (is_array($items) && count($items) > 0) {
                    $code = $items[0]; // Receive the status code in the array (if there is no error, this value will be the SMS ID)
                } else {
                    $code = 0;
                }

                // Analysis and review of various errors
                if ($code == 1) {
                    return ResponseHelper::systemErrorResponse(0, "خطای احراز هویت پنل پیامکی", [], 200, 104);
                } else if ($code == 2) {
                    return ResponseHelper::systemErrorResponse(0, "پارامترها به درستی ارسال نشده اند", [], 200, 105);
                } else if ($code == 3) {
                    return ResponseHelper::systemErrorResponse(0, "طول آرایه ها بیشتر از 100 میباشد", [], 200, 106);
                } else if ($code == 4) {
                    return ResponseHelper::systemErrorResponse(0, " طول آرایه ی فرستنده و گیرنده و متن پیام با یکدیگر تطابق ندارد.", [], 200, 107);
                } else if ($code == 5) {
                    return ResponseHelper::systemErrorResponse(0, "امکان گرفتن پیام جدید وجود ندارد", [], 200, 108);
                } else if ($code == 6) {
                    return ResponseHelper::systemErrorResponse(0, "  - حساب کاربری غیر فعال می باشد.", [], 200, 109);
                } else if ($code == 7) {
                    return ResponseHelper::systemErrorResponse(0, " امکان دسترسی به خط مورد نظر وجود ندارد.", [], 200, 110);
                } else if ($code == 8) {
                    return ResponseHelper::systemErrorResponse(0, "شماره گیرنده نامعتبر است.", [], 200, 111);
                } else if ($code == 9) {
                    return ResponseHelper::systemErrorResponse(0, "حساب اعتبار ریالی مورد نیاز را دارا نمی باشد.", [], 200, 112);
                } else if ($code == 10) {
                    return ResponseHelper::systemErrorResponse(0, "خطایی در سیستم رخ داده است . دوباره سعی کنید.", [], 200, 113);
                } else if ($code == 11) {
                    return ResponseHelper::systemErrorResponse(0, "نامعتبر می باشد . IP", [], 200, 114);
                } else if ($code == 20) {
                    return ResponseHelper::systemErrorResponse(0, "شماره مخاطب فیلتر شده می باشد.", [], 200, 115);
                } else if ($code == 21) {
                    return ResponseHelper::systemErrorResponse(0, "ارتباط با سرویس دهنده قطع می باشد.", [], 200, 116);
                } else if ($code == 24) {
                    return ResponseHelper::systemErrorResponse(0, "امکان استفاده از این سرویس در پلن رایگان وجود ندارد.", [], 200, 117);
                } else {
                    // Creating a new model and saving the created verification code
                    $smsVerify = new SmsVerify();
                    $smsVerify->phone = $receptor;
                    $smsVerify->verifyCode = $param1;
                    $smsVerify->status = 0;
                    $smsVerify->save();

                    return ResponseHelper::successResponse(1, "کد تاییدی با موفقیت ارسال شد", [], 200);
                }
            }

        } catch (Exception $e) {
            // Handle any exceptions that occurred during the request to ghasedak panel
            return ResponseHelper::systemErrorResponse(0, $e->getMessage(), [], 200, $e->getCode());
        }

    }
    public function sendOtherApp($receptor, $templateName)
    {
        // Check for the existence of a pre-confirmation code
        $checkVerifyIsActive = SmsVerify::where('phone', $receptor)->where('status', 0)->first();

        if ($checkVerifyIsActive) {
            return response()->json(['status' => "خطا", 'message' => 'کد تاییدی از قبل ارسال شده است', 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
        }

        // Creating a verification code
        $param1 = rand(1000, 9999);

        // Create a new Guzzle client instance
        $client = new Client();

        // Define the request parameters
        $params = [
            'receptor' => $receptor,
            'template' => $templateName,
            'type' => 1,
            'param1' => $param1
        ];

        try {
            // Send a POST request to the specified URL with the parameters
            $response = $client->request('POST', 'https://api.ghasedak.me/v2/verification/send/simple', [
                'form_params' => $params,
                'headers' => [
                    'apikey' => '3412edc435274dc0712544e818fc1d23355a3c1712811904146f7871376a4844',
                    'cache-control' => 'no-cache',
                    'content-type' => 'application/x-www-form-urlencoded',
                    'Accept' => 'application/json'
                ]
            ]);

            // Get the response body as a string
            $body = $response->getBody()->getContents();

            $responseArray = json_decode($body, true); // convert json to array

            if ($responseArray !== null && array_key_exists('result', $responseArray)) {
                // find response code from result of ghasedak panel
                $items = $responseArray['items'];

                if (is_array($items) && count($items) > 0) {
                    $code = $items[0]; // Receive the status code in the array (if there is no error, this value will be the SMS ID)
                } else {
                    $code = 0;
                }

                // Analysis and review of various errors
                $errorMessages = [
                    1 => 'خطای احراز هویت پنل پیامکی',
                    2 => 'پارامترها به درستی ارسال نشده اند',
                    3 => 'طول آرایه ها بیشتر از 100 میباشد',
                    4 => 'طول آرایه ی فرستنده و گیرنده و متن پیام با یکدیگر تطابق ندارد.',
                    5 => 'امکان گرفتن پیام جدید وجود ندارد',
                    6 => 'حساب کاربری غیر فعال می باشد.',
                    7 => 'امکان دسترسی به خط مورد نظر وجود ندارد.',
                    8 => 'شماره گیرنده نامعتبر است.',
                    9 => 'حساب اعتبار ریالی مورد نیاز را دارا نمی باشد.',
                    10 => 'خطایی در سیستم رخ داده است . دوباره سعی کنید.',
                    11 => 'نامعتبر می باشد . IP',
                    20 => 'شماره مخاطب فیلتر شده می باشد.',
                    21 => 'ارتباط با سرویس دهنده قطع می باشد.',
                    24 => 'امکان استفاده از این سرویس در پلن رایگان وجود ندارد.'
                ];

                if (array_key_exists($code, $errorMessages)) {
                    return response()->json(['status' => "خطا", 'message' => $errorMessages[$code], 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
                } else {
                    // Creating a new model and saving the created verification code
                    $smsVerify = new SmsVerify();
                    $smsVerify->phone = $receptor;
                    $smsVerify->verifyCode = $param1;
                    $smsVerify->status = 0;
                    $smsVerify->save();

                    return response()->json(['status' => "success", 'message' => 'درخواست با موفقیت انجام شد', 'code' => (object)['value' => 200, 'description' => 'OK'], 'data' => (object)['verificationCode' => $param1]], 200);
                }
            }
        } catch (Exception $e) {
            // Handle any exceptions that occurred during the request to ghasedak panel
            return response()->json(['status' => "error", 'message' => $e->getMessage(), 'code' => (object)['value' => 400, 'description' => 'Bad Request']], 400);
        }
    }


}
