<?php

namespace App\Models\ApiKey;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApikeyModel extends Model
{
    use HasFactory;
    protected $table = 'apikey';

    protected $fillable = ['apikey', 'created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->apikey = static::generateApiKey();
        });
    }

    protected static function generateApiKey()
    {
        // ایجاد یک hash از ساعت فعلی و استفاده از آن به عنوان apikey
        $currentDateTime = Carbon::now();
        return hash('md5', $currentDateTime->isoFormat("YYYY-MM-DD HH"));
    }
}
