<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class JobQueue extends Model
{
    // اگر نام جدول با نام مدل متفاوت باشد، باید آن را تعیین کنید
    protected $table = 'job_queue';

    // مشخص کردن پرایمری کی و نوع آن (در اینجا فرض می‌کنیم 'id' کلید اصلی است)
    protected $primaryKey = 'id';

    // اگر کلید اصلی به صورت عدد صحیح خودکار افزایش نیابد، می‌توانید این را مشخص کنید
    public $incrementing = true;

    // نوع کلید اصلی (در اینجا عدد صحیح است)
    protected $keyType = 'int';

    // مشخص کردن این که زمان‌های ایجاد و به‌روزرسانی به طور خودکار مدیریت شوند
    public $timestamps = true;

    // پر کردن لیست سفید برای مشخص کردن فیلدهایی که می‌توانند به طور جمعی پر شوند
    protected $fillable = [
        'job_type',
        'ip_address',
        'username',
        'password',
        'job_status',
        'json'
    ];

    // اگر نیاز دارید برخی فیلدها به طور اتوماتیک از نوع JSON تبدیل شوند، می‌توانید از mutator استفاده کنید
    protected $casts = [
        'json' => 'array',
    ];
}