<?php

namespace App\Models;

use App\Models\ProvinceAndCity\CityModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class WalletModel extends Model
{
    use HasFactory;

    protected $table = 'wallet';

    protected $fillable = [
      'user_id',
      'city_id',
      'credit',
      'created_at',
      'updated_at',
    ];
    public static function filterByUserId($userId)
    {
        $query = DB::table('wallet'); // Replace with your actual table name

        if ($userId) {
            $query->where('user_id', $userId);
        }

        return $query->get(); // Or use other methods like paginate()
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function city()
    {
        return $this->belongsTo(CityModel::class);
    }
}
