<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJobQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_queue', function (Blueprint $table) {
            $table->id(); // Creates an auto-incrementing UNSIGNED BIGINT (primary key) column.
            $table->string('job_type'); // Defines the type of job or task.
            $table->string('ip_address');
            $table->string('username');
            $table->string('password');
            $table->enum('job_status', ['PENDING', 'IN_PROGRESS', 'COMPLETED', 'FAILED'])->default('PENDING'); // Defines the job status.
            $table->text('json'); // Stores the data needed for job execution.
            $table->timestamps(); // Adds created_at and updated_at columns.
            $table->text('error_message')->nullable(); // Optional column for error messages.
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('job_queue');
    }
}