<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\Payment\GatewayController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\ApplicationsController;
use App\Http\Controllers\ApiKey\ApikeyContoller;
use App\Http\Controllers\MicrosoftSqlRoutes\MicrosoftController;
use App\Http\Controllers\Trancation\TransactionController;
use Illuminate\Http\Request;
use App\Http\Controllers\Wallet;
use App\Http\Controllers\ProvinceAndCity\ProvinceAndCityController;
use App\Http\Controllers\Qrcode\QrcodeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
/** Test Routes Without Need Api key and Jwt Token */
Route::post('v1/savedFinger', [MicrosoftController::class, 'savedFinger']);
Route::post('v1/getUserInformation', [MicrosoftController::class, 'getUserInformation']);
Route::post('v1/updateUserWallet', [MicrosoftController::class, 'updateUserWallet']);
Route::post('v1/pusherTest', [MicrosoftController::class, 'pusherTest']);

/** OTP Routes */
Route::post('v1/sendAuthSms', [SmsController::class, 'sendSms']);
Route::post('v1/smsAuthVerification', [SmsController::class, 'verify']);
/**  Other Apps OTP Routes */
Route::post('v1/sendAuthSms', [SmsController::class, 'sendSms']);
Route::post('v1/smsAuthVerification', [SmsController::class, 'verify']);


/** WALLET Routes */
Route::post('v1/modifyCredit', [WalletController::class, 'modifyCredit']);
Route::post('v1/getUserWallet', [WalletController::class, 'getUserWallet']);

/** BUS Lines Routes */
Route::get('v1/getBusLocations', [\App\Http\Controllers\MicrosoftSqlRoutes\BusController::class, 'getBusLocations']);

/** Rules */
Route::get('v1/getApplicationRules', [ApplicationsController::class,'getApplicationRules']);

/** JWT USER Needed Actions With Auth */
Route::group(['middleware' => 'jwt.auth'], function () {

    /** User Routes */
    // Retrieves information about the authenticated user with a JWT token.
    Route::get('v1/getUser', [AuthController::class, 'getUser']);
    Route::post('v1/updateUser', [AuthController::class, 'updateUser']);
    Route::get('v1/getPostsUserShared', [AuthController::class, 'getPostsUserShared']);
    Route::post('v1/savePost', [\App\Http\Controllers\Post\PostController::class, 'savePost']);
    Route::get('v1/getSavedPost', [\App\Http\Controllers\Post\PostController::class, 'getSavedPost']);
    // Validates the JWT token passed in the request headers.
    Route::get('v1/validateToken', [AuthController::class, 'validateToken']);
    // Retrieves the API key for the authentication process.
    Route::get('v1/getApiKey', [ApikeyContoller::class, 'getApiKey']);
    // Logs out the user.
    Route::get('v1/logout', [AuthController::class, 'logout']);
    // Refreshes the JWT token.
    Route::get('v1/refresh', [AuthController::class, 'refresh']);


    /** Province And City Routes */
    // Retrieves the list of provinces and cities.
    Route::get('v1/getProvince', [ProvinceAndCityController::class, 'getProvinceAndCityList']);
    // Retrieves the list of cities based on the provided province ID.
    Route::post('v1/getCityWithProvinceID', [ProvinceAndCityController::class, 'getCityWithProvinceID']);


    /** Qrcode Routes */
    Route::post('v1/generateQrcode', [QrcodeController::class, 'generateQrcode']);

    /** Posts Routes */
    Route::get('v1/allPostsInHome', [\App\Http\Controllers\Post\PostController::class, 'allPostsInHome']);
    Route::post('v1/postDetail', [\App\Http\Controllers\Post\PostController::class, 'postDetail']);
    Route::post('v1/postSearch', [\App\Http\Controllers\Post\PostController::class, 'postSearch']);
//    Route::post('v1/insertPost', [\App\Http\Controllers\Post\PostController::class, 'insert']);
    Route::post('v1/updatePost', [\App\Http\Controllers\Post\PostController::class, 'update']);
    Route::post('v1/insertPhoto', [\App\Http\Controllers\Post\PostController::class, 'insertPhoto']);
    Route::post('v1/insertPost', [\App\Http\Controllers\Post\PostController::class, 'insert']);
    Route::post('v1/getPostBySubsCategoryID', [\App\Http\Controllers\Post\PostController::class, 'getPostBySubsCategoryID']);

    /** Category List */
    Route::get('v1/getCategory', [\App\Http\Controllers\Category\CategoryController::class, 'getCategory']);
    Route::post('v1/getSubsCategory', [\App\Http\Controllers\Category\SubCategoryController::class, 'getSubCategoryById']);

    /** Wallet Api */
    Route::get('v1/verifyWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'verifyWallet']);
    Route::post('v1/insertWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'insertWallet']);
    Route::post('v1/deleteWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'delete']);
    Route::get('v1/deleteAllWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'deleteAll']);
    Route::get('v1/getUserWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'getUserWallet']);
    Route::post('v1/syncWallet', [\App\Http\Controllers\Wallet\WalletController::class, 'syncWallet']);
    Route::post('v1/getLatLang', [QrcodeController::class, 'getLatLang']);
    Route::get('v1/getAllCity', [ProvinceAndCityController::class,'getAllCity']);
    Route::post('v1/createPaymentLink', [GatewayController::class,'createPaymentLink']);

    //** Transactions List */

    // insert new Transactions
    Route::post('v1/insertTransaction', [TransactionController::class,'insert']);
    // all transactions in system
    Route::get('v1/getAllTransactions', [TransactionController::class,'getAllTransactions']);
    Route::get('v1/dsda', [QrcodeController::class,'dsda']);
    // delete transaction
    Route::get('v1/deleteUserTransactions', [TransactionController::class,'deleteUserTransactions']);
    Route::get('v1/deleteAllTransactions', [TransactionController::class,'deleteAllTransactions']);
    // user transactions
    Route::get('v1/getUserTransactions', [TransactionController::class,'getUserTransactions']);

    Route::post('v1/getMerchantID', [ProvinceAndCityController::class,'getMerchantID']);
    Route::post('v1/insertCities', [ProvinceAndCityController::class,'insertCities']);

});
